#!/bin/sh
#----
# ΥץȤϥȥץؤԤΤΤǤ
#
PKG=$1

AGENT_DIR=/opt/proscan/agent
TEMP_DIR=/tmp/psmt
ARCH=`arch 2> /dev/null`
if [ "$ARCH" = "" ]
then
    ARCH=`uname`
fi
if [ "$ARCH" = "AIX" ]
then
    RN=`uname -v`
    ARCH="$ARCH$RN"
fi

CONFIG=$AGENT_DIR/psmt_agent.conf
if [ -f $CONFIG ]
then
    . $CONFIG
fi

if [ "$MANAGER" = "" ]
then
    MANAGER=`awk -F= '/^MANAGER=/{print $2}' $AGENT_DIR/bin/update.sh`
fi
if [ "$PORT" = "" ]
then
    PORT=`awk -F= '/^PORT=/{print $2}' $AGENT_DIR/bin/update.sh`
fi
TEST=0

if [ ! -f $PKG ]
then
    exit 1
fi

copy_file() {
    SRC=$1
    DST=$2
    
    if [ "$3" = "conv" ]
    then
        sed -e "s/192.168.100.155/$MANAGER/g;s/8505/$PORT/g" $SRC > $DST
        chmod u+x $DST
    else
        cp -p $SRC $DST
    fi
}

if [ -d $TEMP_DIR ]
then
    rm -rf $TEMP_DIR
fi
mkdir $TEMP_DIR
cd $TEMP_DIR
tar zxf $PKG
cd psmt_agent*
CURRENT=`pwd`
cd bin
if [ $? -ne 0 ]
then
    exit 1
fi

OLD_VER=`$AGENT_DIR/bin/agent -b`
if [ "$ARCH" = "ppc64" ]
then
    VER=`./agent_ppc64 -b`
    mv agent_ppc64 agent.new
elif [ "$ARCH" = "s390" -o "$ARCH" = "s390x" ]
then
    VER=`./agent_s390 -b`
    mv agent_s390 agent.new
elif [ "$ARCH" = "x86_64" ]
then
    VER=`./agent_x86_64 -b`
    mv agent_x86_64 agent.new
elif [ "$ARCH" = "AIX6" ]
then
    VER=`./agent_aix6 -b`
    mv agent_aix6 agent.new
elif [ "$ARCH" = "AIX7" ]
then
    VER=`./agent_aix7 -b`
    mv agent_aix7 agent.new
else
    VER=`./agent_i386 -b`
    mv agent_i386 agent.new
fi
rm -f agent_*

if [ "$VER" != "$OLD_VER" -o $TEST -eq 1 ]
then
    cp -pr $AGENT_DIR/bin $AGENT_DIR/bin.back
    cp -pr $AGENT_DIR/script $AGENT_DIR/script.back
    
    cd $CURRENT/bin
    for f in *
    do
        copy_file $f $AGENT_DIR/bin/$f conv
    done
    if [ -f agent_replace.sh ]
    then
    	copy_file agent_replace.sh $AGENT_DIR/bin/agent_replace.sh
    fi
    
    cd $CURRENT/script
    for f in *
    do
        copy_file $f $AGENT_DIR/script/$f conv
    done
    
    if [ -f $CURRENT/bin/psmt_agent ]
    then
        copy_file $AGENT_DIR/bin/psmt_agent /etc/init.d/psmt_agent
    fi
    
    cd $AGENT_DIR
    rm -rf bin.back script.back
    
    /etc/init.d/psmt_agent stop
    cp $CURRENT/bin/agent.new $AGENT_DIR/bin/agent
    /etc/init.d/psmt_agent start
fi

exit 0
