#!/bin/sh
#--------------------
# PSMT 2.3
# 2013.03.01 
# 2013.10.10 Powerб
# 2021.02.09 PSMTѤѹ
# 2022.11.09 SCANLIBPATHɲ
# 2023.07.07 SCAN,UPTIME,TIMEOUTѿ̾ѹSCAN_PATHѿ
# 2023.10.11 MailǽɲáʥǥեȤϥȥȡ
#-------------------
# filescan.sh
#-------------------
INSTALL_DIR=/opt/proscan/agent
OUTPUT=/var/opt/proscan/tmp/scan.log
PS_CONFIG=$INSTALL_DIR/conf/scan.conf
CONFIG=$INSTALL_DIR/conf/psmt_agent.conf
# for Mail
SUBJECT="scan log"
FROM=root
TO=root@localhost

# config read
if [ -f $CONFIG ]
then
    . $CONFIG
fi
if [ "$MANAGER" = "" ]
then
    MANAGER=192.168.100.155
fi
SCAN_PATH=$1
SCAN_TIMEOUT=$2
SCAN_COMMAND=/opt/proscan/bin/proscanfs
MAIL=`which mail`

START=`date +%s`
rm -f $OUTPUT > /dev/null 2>&1

LIBPATH=/usr/lib/clamav $SCAN_COMMAND -c $PS_CONFIG -n 15 -o $OUTPUT $SCAN_PATH
RES=$?

END=`date +%s`

RC=0
SCAN_UPTIME=`expr $END - $START`
if [ "$SCAN_TIMEOUT" = "" ]
then
    SCAN_TIMEOUT=1800
fi
if [ $RES -eq 0 ]
then
    if [ $SCAN_UPTIME -ge $SCAN_TIMEOUT ]
    then
        logger "Warnnig: scan time over"
        RC=255
    else
        logger "Successfully: scan complete"
    fi
else
    logger "Failed: proscanfs error"
    RC=$RES
fi

$INSTALL_DIR/script/poststatus $MANAGER

# for Mail
#cat -v $OUTPUT | $MAIL -s "$SUBJECT" -r "$FROM" $TO

rm $OUTPUT
exit $RC
