#!/bin/sh
#--------------------
# PSMT 2.1
# 2014.02.17 create
#-------------------
# update
#-------------------
CONFIG=/opt/proscan/agent/conf/psmt_agent.conf
if [ -f $CONFIG ]
then
    . $CONFIG
fi
if [ "$MANAGER" = "" ]
then
    MANAGER=192.168.100.155
fi
if [ "$PORT" = "" ]
then
    PORT=8505
fi

CLAMAV=/usr/lib/clamav
TEMP=.update_temp_$$
AVENGINE_CONF=/etc/clamav/clamd.conf
PID_FILE=/var/run/clamd.pid

cd $CLAMAV
mkdir $TEMP
cd $TEMP

wget -O main.cvd http://$MANAGER/main.cvd
RC1=$?
wget -O daily.cvd http://$MANAGER/daily.cvd
RC2=$?
wget -O bytecode.cvd http://$MANAGER/bytecode.cvd
RC3=$?

cd $CLAMAV

if [ $RC1 -eq 0 -a $RC2 -eq 0 -a $RC3 -eq 0 ]
then
    cp $TEMP/*.cvd .
    rm *.cld
    if [ -f "$AVENGINE_CONF" ]
    then
	PID_FILE=`awk '/PidFile /{print $2}' $AVENGINE_CONF`
    fi
    if [ -f "$PID_FILE" ]
    then
	PID=`cat $PID_FILE`
	kill -USR2 $PID
    fi
    update=`date '+%Y/%m/%d %H:%M:%S'`
fi

rm -rf $TEMP

/opt/proscan/agent/script/postversion $MANAGER "$update"

exit 0
