#!/bin/sh
#-----------------------------------------------------------
# ProScan Management Tool Agent Installer Ver. 2.3.13
#
# All Rights Reserved, Copyright (C) Promark Inc. 2006-2024
#
# 2023.06.19 update
# 2024.12.15 T|[gARCHs390AAIXAppc64leAx86_64݂̂
#	@@ Linux̃X^[gAbvXNvgsystemctl݂̂
#
MANAGER=$1
PORT=$2
CURRENT_DIR=`pwd`
INSTALL_DIR=/opt/proscan/agent
if [ "$MANAGER" = "" ]
then
    echo "Usage: install.sh manager [port]"
    exit 1;
fi
if [ "$PORT" = "" ]
then
    PORT=8505
fi

make_dir() {
    DIR_NAME=$1
    DIR=""
    for dir in `echo $DIR_NAME|awk '{n=split($0,path,"/")} END{for(i=1;i<=n;i++) printf("%s ",path[i])}'`
    do
        DIR="$DIR/$dir"
        if [ ! -d $DIR ]
        then
            mkdir $DIR
        fi
    done
}

copy_file() {
    SRC=$1
    DST=$2
    
    if [ "$3" = "conv" ]
    then
        sed -e "s/192.168.100.155/$MANAGER/g;s/8505/$PORT/g" $SRC > $DST
    else
        cp -p $SRC $DST
    fi
}

# OS version check
OS=`uname`
if [ "$OS" = "Linux" ]
then
    if [ ! -f /etc/os-release ]
    then
	echo "[error] Linux only support RedHat"
	exit
    fi
    support=0
    . /etc/os-release
    for os in $ID $ID_LIKE
    do
	if [ "$os" = "rhel" ]
	then
	    support=1
	    break
	fi
    done
    if [ $support -eq 0 ]
    then
	echo "[error] Linux only support RedHat"
	exit
    fi
    VER=`echo $VERSION_ID|awk '{print $0 * 100}'`
    if [ $VER -lt 800 ]
    then
	echo "[error] Only RedHat 8 and higher is supported"
	exit
    fi

elif [ "$OS" = "AIX" ]
then
    OSV=`oslevel|cut -d. -f1`
    OSSV=`oslevel|cut -d. -f2`
    if [ $OSV -lt 7 -o $OSSV -lt 2 ]
    then
	echo "[error] AIX $OSV.$OSSV not supported"
	exit
    fi
else
    echo "[error] $OS not supported"
    exit
fi

# Directory create
make_dir $INSTALL_DIR
cd $INSTALL_DIR
for d in bin script data conf download
do
    if [ ! -d $d ]
    then
        mkdir $d
    fi
done

# Copy module
cd $CURRENT_DIR/bin
for f in *.sh
do
    copy_file $f $INSTALL_DIR/bin/$f conv
done
copy_file psmt_agent $INSTALL_DIR/bin/psmt_agent
ARCH=`arch 2> /dev/null`
if [ "$ARCH" = "" ]
then
    ARCH=$OS
fi
if [ "$ARCH" = "" -o "$ARCH" = "ppc64" -o "$ARCH" = "i386" -o "$ARCH" = "i586" ]
then
    echo "[error] PSMT agent is not supported"
    exit 9
fi
if [ "$ARCH" = "s390" -o "$ARCH" = "s390x" ]
then
    cp -p agent_s390 $INSTALL_DIR/bin/agent
fi
if [ "$ARCH" = "ppc64le" ]
then
    cp -p agent_ppc64le $INSTALL_DIR/bin/agent
fi
if [ "$ARCH" = "x86_64" ]
then
    cp -p agent_x86_64 $INSTALL_DIR/bin/agent
fi
if [ "$ARCH" = "AIX" ]
then
    REL=`uname -v`
    cp -p agent_aix $INSTALL_DIR/bin/agent
fi
chmod a+x $INSTALL_DIR/bin/*

cd $CURRENT_DIR/script
for f in *
do
    copy_file $f $INSTALL_DIR/script/$f conv
done
chmod a+x $INSTALL_DIR/script/*

copy_file $CURRENT_DIR/conf/psmt_agent.conf $INSTALL_DIR/conf/psmt_agent.conf conv
cp $CURRENT_DIR/conf/scan.conf $INSTALL_DIR/conf

if [ "$OS" = "Linux" ]
then
    if [ -d /lib/systemd/system ]
    then
	cp $CURRENT_DIR/conf/psmt_agent.service /lib/systemd/system
	systemctl start psmt_agent.service
	systemctl enable psmt_agent.service
	systemctl status psmt_agent.service
	START=1
    elif [ -d /etc/init.d ]
    then
	cp $INSTALL_DIR/bin/psmt_agent /etc/init.d
	chmod a+x /etc/init.d/psmt_agent
	if [ "$START" = "" ]
	then
	    /etc/init.d/psmt_agent start
	fi
	echo "[Warning] startup script could not be set"
    fi
elif [ "$OS" = "AIX" ]
then
    if [ ! -d /etc/rc.d/init.d ]
    then
	mkdir /etc/rc.d/init.d
    fi
    RC=/etc/rc.d/init.d/psmt_agent
    cp $INSTALL_DIR/bin/psmt_agent $RC
    chmod a+x $RC
    if [ ! -f /etc/rc.d/rc2.d/S99psmt_agent ]
    then
	ln -s $RC /etc/rc.d/rc2.d/S99psmt_agent
	ln -s $RC /etc/rc.d/rc2.d/K99psmt_agent
    fi
    /etc/rc.d/rc2.d/S99psmt_agent start
fi
