#!/bin/sh
#-------------------------------------------------
# ProScan Management Tool Agent Updater
#
# All Rights Reserved, Copyright (C) Promark Inc. 2022-2024
#
#---- change log
# 2022.02.04 PSMT agent upgrade script
# 2024.12.26 Build 13 upgrade scrip
# 2025.01.28 oCisedƂȂC
#
MANAGER=$1
PORT=$2
CURRENT_DIR=`pwd`
INSTALL_DIR=/opt/proscan/agent

# check exec uid
ID=`id|grep 'uid=0(root)'`
if [ "$ID" = "" ]
then
    echo "You must run this program as root."
    exit 1
fi

make_dir() {
    DIR_NAME=$1
    DIR=""
    for dir in `echo $DIR_NAME|awk '{n=split($0,path,"/")} END{for(i=1;i<=n;i++) printf("%s ",path[i])}'`
    do
        DIR="$DIR/$dir"
        if [ ! -d $DIR ]
        then
            mkdir $DIR
        fi
    done
}

copy_file() {
    SRC=$1
    DST=$2
    
    FTYPE=`grep 192.168.100.155 $SRC`
    if [ "$3" = "conv" -a "$FTYPE" != "" ]
    then
        sed -e "s/192.168.100.155/$MANAGER/g;s/8505/$PORT/g" $SRC > $DST
        chmod a+x $DST
    else
        cp -p $SRC $DST
    fi
    chown root $DST
}

# param check
if [ "$MANAGER" = "" ]
then
    echo "Usage: $0 MANAGER [PORT]"
    exit
fi

if [ "$PORT" = "" ]
then
    PORT=8505
fi

# OS version check
OS=`uname`
if [ "$OS" = "Linux" ]
then
    if [ ! -f /etc/os-release ]
    then
	echo "[error] Linux only support RedHat"
	exit
    fi
    support=0
    . /etc/os-release
    for os in $ID $ID_LIKE
    do
	if [ "$os" = "rhel" ]
	then
	    support=1
	    break
	fi
    done
    if [ $support -eq 0 ]
    then
	echo "[error] Linux only support RedHat"
	exit
    fi
    VER=`echo $VERSION_ID|awk '{print $0 * 100}'`
    if [ $VER -lt 800 ]
    then
	echo "[error] Only RedHat 8 and higher is supported"
	exit
    fi

elif [ "$OS" = "AIX" ]
then
    OSV=`oslevel|cut -d. -f1`
    OSSV=`oslevel|cut -d. -f2`
    if [ $OSV -lt 7 -o $OSSV -lt 2 ]
    then
	echo "[error] AIX $OSV.$OSSV not supported"
	exit
    fi
else
    echo "[error] $OS not supported"
    exit
fi

# Copy module
if [ -d $CURRENT_DIR/new/bin ]
then
    cd $CURRENT_DIR/new/bin
    for f in *
    do
        if [ -f $INSTALL_DIR/bin/$f ]
        then
	    cp -p $INSTALL_DIR/bin/$f $INSTALL_DIR/bin/$f.back
        fi
	copy_file $f $INSTALL_DIR/bin/$f conv
    done

    cd $INSTALL_DIR/bin
    ARCH=`arch 2> /dev/null`
    if [ "$ARCH" = "" ]
    then
	ARCH=$OS
    fi
    if [ "$ARCH" = "" -o "$ARCH" = "ppc64" -o "$ARCH" = "i386" -o "$ARCH" = "i586" ]
    then
	echo "[error] PSMT agent is not supported"
	exit 9
    fi
    rm agent
    if [ "$ARCH" = "s390" -o "$ARCH" = "s390x" ]
    then
	cp -p agent_s390 agent
    fi
    if [ "$ARCH" = "ppc64le" ]
    then
	cp -p agent_ppc64le agent
    fi
    if [ "$ARCH" = "x86_64" ]
    then
	cp -p agent_x86_64 agent
    fi
    if [ "$ARCH" = "AIX" ]
    then
	REL=`uname -v`
	cp -p agent_aix agent
    fi
    chmod a+x agent
    chown root agent
fi

if [ -d $CURRENT_DIR/new/script ]
then
    cd $CURRENT_DIR/new/script
    for f in *
    do
        if [ -f $INSTALL_DIR/script/$f ]
        then
	    cp -p $INSTALL_DIR/script/$f $INSTALL_DIR/script/$f.back
        fi
	copy_file $f $INSTALL_DIR/script/$f conv
    done
fi
