#!/bin/sh
#-----------------------------------------------------------
# ProScan Installer Ver. 2.6
#-----------------------------------------------------------
# All Rights Reserved, Copyright (C) Promark Inc. 2004-2024
#-----------------------------------------------------------
# release 2.6 --- ProScan enterprise for IBM Z
#-----------------------------------------------------------
# support OS RHEL8,RHEL9,SuSE15
# ClamAV 1.0.7
# 
RELEASE=2.6.0

CURRENT=`pwd`

LANG=ja_JP.utf-8
export LANG
RN=6.0.6.0
EXEC_USER=root
OAS=off
CLAMAV_DIR=/usr/lib/clamav
PROSCAN_DIR=/opt/proscan
UPDATER=on

logfile=$CURRENT/proscan_install_`date "+%Y%m%d"`.log

WGET=`which wget`
if [ "$WGET" != "" -a ! -x "$WGET" ]
then
    echo "wget command not installed."
    echo "update programe not installed."
    UPDATER=off
    WGET=/usr/bin/wget
fi

# check exec uid
ID=`id|grep 'uid=0(root)'`
if [ "$ID" = "" ]
then
    echo "You must run this program as root."
    exit 1
fi

PS_CMD="ps ax"

# command path
PATH=/sbin:/usr/sbin:/usr/bin:/usr/local/bin:/usr/sbin:/usr/local/sbin:/bin
export PATH

if [ "$1" = "sendmail" -o "$1" = "postfix" -o "$1" = "milter" -o "$1" = "qmail" -o "$1" = "none" -o "$1" = "upgrade" ]
then
   subsystem=$1
else
   echo "usage: $0 options..."
   echo "  new install:"
   echo "    $0 sendmail|postfix|milter|qmail|none [key_file]"
   echo "  upgrade install:"
   echo "    $0 upgrade [key_file]"
   exit 1
fi

make_dir() {
    DIR_NAME=$1
    DIR=""
    for dir in `echo $DIR_NAME|awk '{n=split($0,path,"/")} END{for(i=1;i<=n;i++) printf("%s ",path[i])}'`
    do
        DIR="$DIR/$dir"
        if [ ! -d $DIR ]
        then
            echo "mkdir $DIR" >> $logfile
            mkdir $DIR
        fi
    done
}

set_copy_config() {
    SRC=$1
    DST=$2
    notify="root@localhost"
    super="root@localhost"
    admin="root@localhost"
    wget=`which wget`
    sed -e "s/##NOTIFY_ADDRESS##/$notify/
            s/##SUPERVISOR_ADDRESS##/$super/
            s?##WGET_PATH##?$wget?
            s?##ADMIN_ADDRESS##?$admin?" $SRC > $DST
}

keyfile_install() {
    # Key install
    if [ -f "$key" ]
    then
	cp $key $VAR_DIR/db/keys/proscan3.key
        echo $reg > $VAR_DIR/db/keys/regist.code
	echo "New license key install.($reg.key)" >> $logfile
    else
        echo "$key file not found."
        echo "$key file not found." >> $logfile
    fi
}

# key file setup check
if [ "$2" != "" ]
then
    if [ ! -f "$2" ]
    then
	echo "ERROR: Key file not found. Please specify the correct key file name."
	exit 1
    fi
    CHK1=`echo $2|egrep "^/"`
    CHK2=`echo $2|egrep "^./"`
    if [ "$CHK1" = "" -a "$CHK2" = "" ]
    then
	key="$CURRENT/$2"
    elif [ "$CHK2" != "" ]
    then
	file=`basename $2`
	key="$CURRENT/$file"
    else
	key=$2
    fi
    if [ ! -f "$key" ]
    then
	echo "ERROR: Key file($key) not found."
	exit 1
    fi
    reg=`basename $key|awk -F. '{print $1}'`
    CHK=`echo $reg|egrep "^PSHB"`
    if [ "$CHK" = "" ]
    then
	echo 'ERROR: Bad license key file name. Key file name must begin with "PSHB".'
	exit 1
    fi
fi

# log start
echo "ProScan 6.0.6 install logging v$RELEASE" > $logfile
uname -a >> $logfile
echo "Current Directory : $CURRENT" >> $logfile

# messages
# OS type check
OS=`uname`
echo $OS >> $logfile

# tar command check
TAR=`which tar`
echo "$TAR" >> $logfile

# check ClamAV config directory
if [ ! -d "/etc/clamav" ]
then
    if [ "$subsystem" = "upgrade" ]
    then
	echo "ClamAV not installed"
	exit 1
    fi
    mkdir /etc/clamav
    echo "create /etc/clamav" >> $logfile

fi
CLAMD_CONFIG="/etc/clamav/clamd.conf"
if [ ! -f "$CLAMD_CONFIG" ]
then
    cp $CURRENT/clamd.conf $CLAMD_CONFIG
fi
if [ ! -d "/etc/clamd.d" ]
then
    mkdir /etc/clamd.d
    echo "create /etc/clamd.d" >> $logfile
fi
if [ ! -f "/etc/clamd.d/scan.conf" ]
then
    ln -s $CLAMD_CONFIG /etc/clamd.d/scan.conf
fi
FRESHCLAM_CONFIG="/etc/clamav/freshclam.conf"
if [ ! -f $FRESHCLAM_CONFIG ]
then
    cp $CURRENT/freshclam.conf $FRESHCLAM_CONFIG
fi
if [ ! -f /etc/freshclam.conf ]
then
    ln -s $FRESHCLAM_CONFIG /etc/freshclam.conf
fi
echo "set ClamAV config" >> $logfile

LD_LIBRARY_PATH=$CLAMAV_DIR
LIB_PATH_SET="LD_LIBRARY_PATH=$LD_LIBRARY_PATH"

PRODUCT_NAME="ProScan enterprise for IBM Z"

# Installer start
echo "*** $PRODUCT_NAME 6.0.6 Installer started."
echo "*** Installer version $RELEASE, Copyright (C) Promark Inc. 2004-2024"
echo ""
echo "installer version $RELEASE starting" >> $logfile

CLAMD_RUN=0
CLAMD_CHECK=0
NEGN=`cut -d '/' -f 1 $CURRENT/clamav_version.txt|sed -e 's/ClamAV //'|awk -F. '{printf("%02d%03d%02d",$1,$2,$3)}'`
NVDF=`cut -d '/' -f 2 $CURRENT/clamav_version.txt`
cat $CURRENT/clamav_version.txt >> $logfile
upgrade=0
OWN=root
GRP=root

# release check
if [ -f /etc/os-release ]
then
    OSID=`cat /etc/os-release | grep "^ID=" |cut -d= -f2|sed -e 's/"//g'`
    VERSION=`cat /etc/os-release | grep "^VERSION_ID=" |cut -d= -f2|sed -e 's/"//g'|cut -d. -f1`
    case "$OSID" in
	rhel)
	    SUSE=0
	    RHEL=1
	    ;;
	sles)
	    SUSE=1
	    RHEL=0
	    ;;
	*)
	    echo "This installer support only RedHat or SuSE"
	    echo "This installer support only RedHat or SuSE" >> $logfile
	    cat /etc/os-release >> $logfile
	    exit 1
	    ;;
    esac
    echo "OS TYPE: $OSID $VERSION" >> $logfile
    cat /etc/os-release >> $logfile
elif [ -f /etc/SuSE-release ]
then
    VERSION=`lsb_release -rs` # SuSE - 11
    SUSE=1
    RHEL=0
    echo "OS TYPE: SuSE $VERSION" >> $logfile
    cat /etc/SuSE-release >> $logfile
elif [ -f /etc/redhat-release ]
then
    which lsb_relese > /dev/null 2>&1
    if [ $? -eq 0 ]
    then
	VERSION=`lsb_release -rs`
    else
  	VERSION=`cat /etc/redhat-release|cut -d' ' -f7|cut -d. -f1`
    fi
    SUSE=0
    RHEL=1
    echo "OS TYPE: RedHat VER:$VERSION" >> $logfile
    cat /etc/redhat-release >> $logfile
elif [ -x /usr/sbin/SUSEConnect ]
then
    SUSE=1
    RHEL=0
    VERSION=`/usr/sbin/SUSEConnect -s|cut -d, -f2|cut -d: -f2|cut -d. -f1`
    echo "OS TYPE: SuSE $VERSION" >> $logfile
    /usr/sbin/SUSEConnect -s >> $logfile
else
    echo "This installer support only RedHat or SuSE"
    echo "This installer support only RedHat or SuSE" >> $logfile
    exit 1
fi

cd $CURRENT

# lib link set
if [ -f lib.tar.gz ]
then
	rm lib.tar.gz
fi
if [ -f support_lib.tar.gz ]
then
	rm support_lib.tar.gz
fi
if [ $RHEL -eq 1 ]
then
	ln -s lib_rhel.tar.gz lib.tar.gz
	if [ -f support_lib_rhel.tar.gz ]
	then
	    ln -s support_lib_rhel.tar.gz support_lib.tar.gz
	fi
elif [ $SUSE -eq 1 ]
then
	ln -s lib_sles.tar.gz lib.tar.gz
	if [ -f support_lib_sles.tar.gz ]
	then
	    ln -s support_lib_sles.tar.gz support_lib.tar.gz
	fi
fi

# ClamAV directory check
if [ ! -d "$CLAMAV_DIR" ]
then

    if [ "$subsystem" = "upgrade" ]
    then
	echo "ClamAV not installed"
	exit 1
    fi

    # ClamAV not installed
    mkdir $CLAMAV_DIR
    echo "create $CLAMAV_DIR" >> $logfile

    cd $CLAMAV_DIR

    # clamav install
    echo "ClamAV install"
    echo "ClamAV install" >> $logfile

    echo -n "ClamAV packeage install ... "
    CLAMAV=$CURRENT/lib.tar.gz
    $TAR zxf $CLAMAV
    echo "clamav packeage install" >> $logfile
    if [ -f post_install.sh ]
    then
    	sh post_install.sh > /dev/null 2>&1
    	echo "for ClamAV library linking." >> $logfile
    fi
    echo "done"

    # VDF install
    echo -n "ClamAV vdf install ... "
    CLAMAV_VDF=$CURRENT/vdf.tar.gz
    $TAR zxf $CLAMAV_VDF
    echo "clamav signature install" >> $logfile
    echo "done"

    # Shared library install
    echo -n "Shared library install ... "
    SUPPORTLIB=$CURRENT/support_lib.tar.gz
    if [ -f $SUPPORTLIB ]
    then
	notfound=1
	echo "support library found. check library." >> $logfile
	CNT=`$TAR ztf $SUPPORTLIB|wc -l`
    else
	notfound=0
	echo "support library not found." >> $logfile
	CNT=0
    fi

    while [ $notfound -eq 1 -a $CNT -gt 0 ]
    do
	CHK=`LIBPATH=$CLAMAV_DIR ldd freshclam | grep "not found" | head -1`
	if [ "$CHK" = "" ]
	then
	    notfound=0
	    echo "support library all OK." >> $logfile
	else
	    echo "$CHK" >> $logfile
	    LIB=`echo $CHK|sed -e 's/[\t ]*//g'|cut -d'=' -f1`
	    if [ "$LIB" != "" ]
	    then
		LIB=`basename $LIB`
	    	$TAR zxvf $SUPPORTLIB ./$LIB > /dev/null 2>&1
		if [ $? -eq 0 ]
		then
		    echo "$LIB installed." >> $logfile
		else
		    echo "$LIB not found in support library." >> $logfile
		fi
	    fi
	fi
	CNT=`expr $CNT - 1`
    done

    echo "done"

    if [ -f post_install.sh ]
    then
	sh post_install.sh > /dev/null 2>&1
    fi

    if [ ! -f /etc/ld.so.conf.d/proscan_s390.conf ]
    then
	echo /usr/lib/clamav > /etc/ld.so.conf.d/proscan_s390.conf
	echo /opt/proscan/bin >> /etc/ld.so.conf.d/proscan_s390.conf
    fi
    ldconfig

    chown $OWN:$GRP $CLAMAV_DIR/*
    CLAMD_CHECK=1
    ENG=0
    VDF=0

else
    echo "ClamAV already installed ... "
    echo "ClamAV already installed ... " >> $logfile

    # already installed
    EGN=`export $LIB_PATH_SET; $CLAMAV_DIR/clamd -V -c $CLAMD_CONFIG|cut -d '/' -f 1|sed -e 's/ClamAV //'|awk -F. '{printf("%02d%03d%02d",$1,$2,$3)}'`
    VDF=`export $LIB_PATH_SET; $CLAMAV_DIR/clamd -V -c $CLAMD_CONFIG|cut -d '/' -f 2`
    if [ "$EGN" = "" -o "$VDF" = "" ]
    then
	echo "old version not get" >> $logfile
	export $LIB_PATH_SET
	$CLAMAV_DIR/clamd -V -c $CLAMD_CONFIG >> $logfile 2>&1
	if [ "$ENG" = "" ]
	then
		ENG=0
	fi
	if [ "$VDF" = "" ]
	then
		VDF=0
	fi
    else
	echo "old version is $EGN and $VDF" >> $logfile
    fi

    if [ $NEGN -le $EGN ]
    then
	echo "The current ClamAV($EGN) is new. Did not upgrade."

    elif [ "$subsystem" != "upgrade" ]
    then
	echo -n "The current ClamAV engine old. Do you upgrade ClamAV? (Y/N) "
	read ANS
	if [ "$ANS" = "N" -o "$ANS" = "n" ]
	then
	    echo "Did not upgrade ClamAV."
	else
	    upgrade=1
	fi
    else
	upgrade=1
    fi

    if [ $upgrade -eq 1 ]
    then
	echo "ClamAV upgrade process starting ..."

	# logfile change
	mv $logfile $CURRENT/upgrade.log
	logfile=$CURRENT/upgrade.log
	echo "ClamAV upgrad mode" >> $logfile

	CLAMD_CHECK=1

	PID=`$PS_CMD|grep $CLAMAV_DIR/clamd|grep -v grep|awk '{print $1}'`
	if [ "$PID" != "" ]
	then
	    kill -TERM $PID
	    echo "stop clamd($PID)" >> $logfile
	    CLAMD_RUN=1
	fi

	# old version backup
	if [ -d $CLAMAV_DIR.save ]
	then
	    mv $CLAMAV_DIR.save $CLAMAV_DIR.$$
	fi
	mv $CLAMAV_DIR $CLAMAV_DIR.save
	mkdir $CLAMAV_DIR
	if [ -f $CLAMD_CONFIG.save ]
	then
	    mv $CLAMD_CONFIG.save $CLAMD_CONFIG.$$
	fi
	cp -p $CLAMD_CONFIG $CLAMD_CONFIG.save
	echo "old ClamAV backup" >> $logfile

	# New clamav install
	cd $CLAMAV_DIR
	echo -n "New ClamAV($NEGN) install ... "
	CLAMAV=$CURRENT/lib.tar.gz
	$TAR zxf $CLAMAV

	echo "done"
	echo "New ClamAV library($NEGN) install" >> $logfile

	# New vdf install
	if [ $NVDF -gt $VDF ]
	then
	    echo -n "New ClamAV($NEGN) vdf($NVDF) install ... "
	    CLAMAV_VDF=$CURRENT/vdf.tar.gz
	    $TAR zxvf $CLAMAV_VDF >> $logfile 2>&1
	    echo "done"
	    echo "New ClamAV signature($NVDF) installed" >> $logfile
	fi

	# Shared library install
	echo -n "Shared library install ... "
	SUPPORTLIB=$CURRENT/support_lib.tar.gz
	if [ -f $SUPPORTLIB ]
	then
	    notfound=1
	    echo "support library found. check library." >> $logfile
	    CNT=`$TAR ztf $SUPPORTLIB|wc -l`
	else
	    notfound=0
	    echo "support library not found." >> $logfile
	    CNT=0
	fi

	while [ $notfound -eq 1 -a $CNT -gt 0 ]
	do
	    CHK=`LIBPATH=$CLAMAV_DIR ldd freshclam | grep "not found" | head -1`
	    if [ "$CHK" = "" ]
	    then
		notfound=0
		echo "support library all OK." >> $logfile
	    else
		echo "$CHK" >> $logfile
		LIB=`echo $CHK|sed -e 's/[\t ]*//g'|cut -d'=' -f1`
		if [ "$LIB" != "" ]
		then
		    LIB=`basename $LIB`
	    	    $TAR zxvf $SUPPORTLIB ./$LIB > /dev/null 2>&1
		    if [ $? -eq 0 ]
		    then
			echo "$LIB installed." >> $logfile
		    else
			echo "$LIB not found in support library." >> $logfile
		    fi
		fi
	    fi
	    CNT=`expr $CNT - 1`
	done
	echo "done"

	if [ -f post_install.sh ]
	then
	    sh post_install.sh > /dev/null 2>&1
	fi

	if [ ! -f /etc/ld.so.conf.d/proscan_s390.conf ]
	then
	    echo /usr/lib/clamav > /etc/ld.so.conf.d/proscan_s390.conf
	    echo /opt/proscan/bin >> /etc/ld.so.conf.d/proscan_s390.conf
	fi
	ldconfig

    fi
fi

if [ $CLAMD_CHECK -eq 1 ]
then
    echo "New ClamAV installed. Check library." >> $logfile
    cd $CLAMAV_DIR
    # ClamAV library check
    SUPPORTLIB=$CURRENT/support_lib.tar.gz
    if [ -f $SUPPORTLIB ]
    then
	notfound=1
	echo "support library found. check library." >> $logfile
	CNT=`$TAR ztf $SUPPORTLIB|wc -l`
    else
	notfound=0
	echo "support library not found." >> $logfile
	CNT=0
    fi
    RT=0
    while [ $notfound -eq 1 -a $CNT -gt 0 ]
    do
	CHK=`LIBPATH=$CLAMAV_DIR ldd freshclam | grep "not found" | head -1`
	if [ "$CHK" = "" ]
	then
	    notfound=0
	    echo "support library all OK." >> $logfile
	else
	    echo "$CHK" >> $logfile
	    RT=`expr $RT + 1`
	fi
	echo "$INSTALL_LIB installed." >> $logfile
        CNT=`expr $CNT - 1`
    done

    if [ $RT -ne 0 ]
    then
	echo "ERROR: The required library could not be found."
	echo "ERROR: The required library could not be found." >> $logfile
	LIBPATH=$CLAMAV_DIR ldd freshclam >> $logfile 2>&1
	ls -l $CLAMAV_DIR >> $logfile 2>&1
	if [ -d $CLAMAV_DIR.save ]
	then
		cd /
		rm -rf $CLAMAV_DIR
		mv $CLAMAV_DIR.save $CLAMAV_DIR
		mv $CLAMAV_DIR.$$ $CLAMAV_DIR.save > /dev/null 2>&1
		echo "Old backup restore" >> $logfile 2>&1
		ls -l $CLAMAV_DIR >> $logfile 2>&1
	fi
	exit 1
    fi

    VER=`export $LIB_PATH_SET; $CLAMAV_DIR/clamd -V -c $CLAMD_CONFIG|cut -d '/' -f 1|sed -e 's/ClamAV //'|awk -F. '{printf("%02d%03d%02d",$1,$2,$3)}'`
    if [ "$NEGN" = "$VER" ]
    then
	echo "New ClamAV install complete"
	echo "New ClamAV install complete" >> $logfile
    elif [ "$NEGN" = "" -o "$VER" = "" ]
    then
	echo "ERROR: New ClamAV install failed. ClamAV version is not get."
	echo "ERROR: New ClamAV install failed. ClamAV version is not get." >> $logfile
	echo "clamd -V -c $CLAMD_CONFIG" >> $logfile
	LIBPATH=$CLAMAV_DIR $CLAMAV_DIR/clamd -V -c $CLAMD_CONFIG >> $logfile 2>&1
	ls -l $CLAMAV_DIR >> $logfile 2>&1
	if [ "$UNINSTALL_SUPPORTLIB" != "cd /opt/freeware/lib" ]
	then
		eval $UNINSTALL_SUPPORTLIB
		echo "Shared library restore" >> $logfile 2>&1
	fi
	exit 1
    else
	echo "ERROR: New ClamAV install failed. version missmuch."
	echo "ERROR: New ClamAV install failed. version missmuch." >> $logfile
	echo "       New Engine Version: $NENG, Install Engine Version: $VER" >> $logfile
	export $LIB_PATH_SET
	if [ -d $CLAMAV_DIR.save ]
	then
		cd /
		rm -rf $CLAMAV_DIR
		mv $CLAMAV_DIR.save $CLAMAV_DIR
		mv $CLAMAV_DIR.$$ $CLAMAV_DIR.save > /dev/null 2>&1
		echo "Old backup restore" >> $logfile 2>&1
	fi
	ls -l $CLAMAV_DIR >> $logfile 2>&1
	if [ "$UNINSTALL_SUPPORTLIB" != "cd /opt/freeware/lib" ]
	then
		eval $UNINSTALL_SUPPORTLIB
		echo "Shared library restore" >> $logfile 2>&1
	fi
	exit 1
    fi
fi

# start
cd $CURRENT
CURRENT_DIR=$CURRENT

# initialize
BASE_DIR=$PROSCAN_DIR
CONFIG_DIR=/etc/opt/proscan
VAR_DIR=/var/opt/proscan
CRON_TAB=/tmp/crontab.proscan
MODULE_DIR=bin_$RN
if [ ! -d "$CURRENT_DIR/$MODULE_DIR" ]
then
    MODULE_DIR=bin
fi
if [ -f $CURRENT_DIR/proscan_cache.tar.gz ]
then
    CACHE_FILE=$CURRENT_DIR/proscan_cache.tar.gz
    CACHE_SET=1
else
    CACHE_SET=0
fi

HOSTNAME=`hostname`
if [ "$HOSTNAME" = "" ]
then
    HOSTNAME=localhost
fi
echo "hostname=$HOSTNAME" >> $logfile
umask 0022

# upgrade task
if [ "$subsystem" = "upgrade" ]
then
    echo "Upgrade mode ::::" >> $logfile

    # check real subsystem
    if [ ! -d /opt/proscan ]
    then
	echo "ProScan enterprise not installed"
	exit 1
    fi

    # MTA check
    subsystem=none
    MTA=`netstat -na|grep -v 127.0.0.1|grep :25`
    if [ "$MTA" != "" ]
    then
	POSTFIX=`ps ax|grep postfix|grep -v grep`
	SENDMAIL=`ps ax|grep sendmail|grep -v grep`
	QMAIL=`ps ax|grep qmail-smtpd|grep -v grep`
	MILTER=`ps ax|grep proscanlm|grep -v grep`
	if [ "$POSTFIX" != "" ]
	then
	    CHK=`grep proscanms /etc/postfix/master.cf`
	    if [ "$CHK" != "" ]
	    then
		subsystem=postfix
	    fi
	    if [ "$MILTER" != "" ]
	    then
		subsystem=milter
	    fi
	elif [ "$SENDMAIL" != "" ]
	then
	    CHK=`grep proscanms /etc/mail/sendmail.cf`
	    if [ "$CHK" != "" ]
	    then
		subsystem=sendmail
	    fi
	    if [ "$MILTER" != "" ]
	    then
		subsystem=milter
	    fi
	elif [ "$QMAIL" != "" -a -f /var/qmail/bin/qmail-que ]
	then
	    subsystem=qmail
	fi
    fi

    # subsystem check
    if [ -f $BASE_DIR/contrib/.subsystem ]
    then
	SUBSYS=`cat $BASE_DIR/contrib/.subsystem`
    else
	SUBSYS=none
    fi
    if [ "$SUBSYS" != "" -a "$SUBSYS" != "$subsystem" ]
    then
	echo "subsystem miss match($SUBSYS)" >> $logfile
	subsystem=$SUBSYS
    fi
    echo "Upgrade subsystem : $SUBSYS" >> $logfile

    # directory check
    if [ -d $BASE_DIR ]
    then
	if [ -d $BASE_DIR.save ]
	then
	    mv $BASE_DIR.save $BASE_DIR.$$
	fi
	cp -pr $BASE_DIR $BASE_DIR.save
    fi
    if [ -d $CONFIG_DIR ]
    then
	if [ -d $CONFIG_DIR.save ]
	then
	    mv $CONFIG_DIR.save $CONFIG_DIR.$$
	fi
	cp -pr $CONFIG_DIR $CONFIG_DIR.save
    fi

    # new module copy
    cp -f $CURRENT_DIR/$MODULE_DIR/* $BASE_DIR/bin
    chmod 755 $BASE_DIR/bin/*
    cp -r $CURRENT_DIR/contrib $BASE_DIR
    chmod 755 $BASE_DIR/contrib/*
    cp $CURRENT_DIR/uninstall.sh $BASE_DIR/contrib

    # excute check
    CHK=`$BASE_DIR/bin/proscan -v|grep ProScan|sed -e 's/^.*Ver.//;s/ .*$//'`
    if [ "$CHK" != "$RN" ]
    then
	echo "ERROR: proscan module not execut."
	rm -fr  $BASE_DIR
	mv $BASE_DIR.save $BASE_DIR
	mv $BASE_DIR.$$ $BASE_DIR.save > /dev/null 2>&1
	rm -fr  $CONFIG_DIR
	mv $CONFIG_DIR.save $CONFIG_DIR
	mv $CONFIG_DIR.$$ $CONFIG_DIR.save > /dev/null 2>&1
	if [ $CLAMD_CHECK -eq 1 ]
	then
		if [ -d $CLAMAV_DIR.save ]
		then
		    cd /
		    rm -rf $CLAMAV_DIR
		    mv $CLAMAV_DIR.save $CLAMAV_DIR
		    mv $CLAMAV_DIR.$$ $CLAMAV_DIR.save > /dev/null 2>&1
		fi
	fi
	exit 1
    fi
    echo "New ProScan module install" >> $logfile

    # license keyfile upgrade
    if [ "$key" != "" ]
    then
	keyfile_install
    fi

    # cache directory setup
    if [ ! -d $VAR_DIR/cache ]
    then
	mkdir $VAR_DIR/cache
	echo "create $VAR_DIR/cache" >> $logfile
    fi
    if [ $CACHE_SET -eq 1 ]
    then
	(cd $VAR_DIR/cache;$TAR zxf $CACHE_FILE)
	echo "creat cache DB" >> $logfile
    fi

    # clamd excut
    if [ $CLAMD_RUN -eq 1 ]
    then
	export $LIB_PATH_SET
	$PROSCAN_DIR/bin/proscan > /dev/null 2>&1
	RETVAL=$?
    else
	RETVAL=0
    fi
    if [ $RETVAL -eq 0 ]
    then
	echo "upgrade successful"
	exit 0
    else
	echo "upgrade failed"
	rm -fr  $BASE_DIR
	mv $BASE_DIR.save $BASE_DIR
	mv $BASE_DIR.$$ $BASE_DIR.save > /dev/null 2>&1
	rm -fr  $CONFIG_DIR
	mv $CONFIG_DIR.save $CONFIG_DIR
	mv $CONFIG_DIR.$$ $CONFIG_DIR.save > /dev/null 2>&1
	if [ $CLAMD_CHECK -eq 1 ]
	then
		if [ -d $CLAMAV_DIR.save ]
		then
		    cd /
		    rm -rf $CLAMAV_DIR
		    mv $CLAMAV_DIR.save $CLAMAV_DIR
		    mv $CLAMAV_DIR.$$ $CLAMAV_DIR.save > /dev/null 2>&1
		fi
	fi
	exit 1
    fi
fi

# subsystem configuration
echo "Subsystem=$subsystem" >> $logfile
echo $subsystem > ".subsystem"
SUBSYS=$subsystem
CONFIG_FILE=$CURRENT_DIR/$SUBSYS.conf
echo "$PRODUCT_NAME $SUBSYS $CONFIG_FILE" >> $logfile
if [ -f $CONFIG_FILE ]
then
    . $CONFIG_FILE
    echo "read $CONFIG_FILE" >> $logfile
else
    echo $CONFIG_FILE
    echo $CONFIG_FILE >> $logfile
    echo "auto install invalid. subsystem file($SUBSYS.conf) not found."
    exit 1
fi

# Subsystem setup
if [ "$subsystem" = "sendmail" -o "$subsystem" = "postfix" -o "$subsystem" = "milter" -o "$subsystem" = "qmail" ]
then
    install_subsys
    if [ $CLAMD_RUN -eq 1 ]
    then
	export $LIB_PATH_SET
	$PROSCAN_DIR/bin/proscan > /dev/null 2>&1
	RETVAL=$?
    else
	RETVAL=0
    fi
    if [ $RETVAL -ne 0 ]
    then
	echo "clamd start error"
	exit 1
    fi
    if [ "$OAS" = "on" ]
    then
	$OAS_RC start
    fi
    touch $CONFIG_DIR/domains
    echo "option auto install complete"
    exit 0
fi

# clamd check
PID=`$PS_CMD|grep $CLAMAV_DIR/clamd|grep -v grep|awk '{print $1}'`
if [ "$PID" != "" ]
then
    kill -TERM $PID
    echo "stop clamd($PID)" >> $logfile
fi

# directory check
if [ ! -d $BASE_DIR ]
then
    make_dir $BASE_DIR
    echo "mkdir $BASE_DIR" >> $logfile
else
    if [ -d $BASE_DIR.save ]
    then
        mv $BASE_DIR.save $BASE_DIR.$$
    fi
    cp -pr $BASE_DIR $BASE_DIR.save
fi
if [ -d $CONFIG_DIR ]
then
    if [ -d $CONFIG_DIR.save ]
    then
        mv $CONFIG_DIR.save $CONFIG_DIR.$$
    fi
    cp -pr $CONFIG_DIR $CONFIG_DIR.save
else
    make_dir $CONFIG_DIR
    echo "mkdir $CONFIG_DIR" >> $logfile
fi
if [ ! -d $VAR_DIR ]
then
    make_dir $VAR_DIR
    echo "mkdir $VAR_DIR" >> $logfile
fi

# proscan directories
if [ ! -d $VAR_DIR/tmp ]
then
    mkdir $VAR_DIR/tmp
    echo "mkdir $VAR_DIR/tmp" >> $logfile
fi
if [ ! -d $VAR_DIR/log ]
then
    mkdir $VAR_DIR/log
    echo "mkdir $VAR_DIR/log" >> $logfile
fi
if [ ! -d $VAR_DIR/db ]
then
    mkdir $VAR_DIR/db
    echo "mkdir $VAR_DIR/db" >> $logfile
fi
if [ ! -d $VAR_DIR/db/keys ]
then
    mkdir $VAR_DIR/db/keys
    echo "mkdir $VAR_DIR/db/keys" >> $logfile
fi
if [ ! -d $VAR_DIR/run ]
then
    mkdir $VAR_DIR/run
    echo "mkdir $VAR_DIR/run" >> $logfile
fi
if [ ! -d $VAR_DIR/quarantine ]
then
    mkdir $VAR_DIR/quarantine
    echo "mkdir $VAR_DIR/quarantine" >> $logfile
fi
if [ ! -d $VAR_DIR/save ]
then
    mkdir $VAR_DIR/save
    echo "mkdir $VAR_DIR/save" >> $logfile
fi
if [ ! -d $VAR_DIR/cache ]
then
    mkdir $VAR_DIR/cache
    echo "mkdir $VAR_DIR/cache" >> $logfile
fi
if [ ! -d $BASE_DIR/bin ]
then
    mkdir $BASE_DIR/bin
    echo "mkdir $BASE_DIR/bin" >> $logfile
fi

# config setting
set_copy_config $CURRENT_DIR/etc/proscan.conf $CONFIG_DIR/proscan.conf.new
mv $CONFIG_DIR/proscan.conf.new $CONFIG_DIR/proscan.conf.$$
sed -e 's/SpamCheck=.*/SpamCheck=no/' $CONFIG_DIR/proscan.conf.$$ > $CONFIG_DIR/proscan.conf.new
rm $CONFIG_DIR/proscan.conf.$$
if [ ! -f $CONFIG_DIR/proscan.conf ]
then
    cp $CONFIG_DIR/proscan.conf.new $CONFIG_DIR/proscan.conf
    echo "cp $CONFIG_DIR/proscan.conf.new $CONFIG_DIR/proscan.conf"  >> $logfile
fi
echo "ProScan configuration file setup ... done"
echo "setup configuration done" >> $logfile

# copy file
cp -r $CURRENT_DIR/template $CONFIG_DIR
echo "cp -r $CURRENT_DIR/template $CONFIG_DIR" >> $logfile
cp $CURRENT_DIR/$MODULE_DIR/* $BASE_DIR/bin
echo "cp $CURRENT_DIR/$MODULE_DIR/* $BASE_DIR/bin" >> $logfile
chmod 755 $BASE_DIR/bin/*
echo "chmod 755 $BASE_DIR/bin/*" >> $logfile
cp -r $CURRENT_DIR/contrib $BASE_DIR
echo "cp -r $CURRENT_DIR/contrib $BASE_DIR" >> $logfile
chmod 755 $BASE_DIR/contrib/*
echo "chmod 755 $BASE_DIR/contrib/*" >> $logfile
cp $CURRENT_DIR/uninstall.sh $BASE_DIR/contrib
cp $CONFIG_FILE $BASE_DIR/contrib

# cache file setup
if [ $CACHE_SET -eq 1 ]
then
	(cd $VAR_DIR/cache;$TAR zxf $CACHE_FILE)
	echo "creat cache DB" >> $logfile
fi

# startup script setup
if [ $RHEL -eq 1 ]
then
    RC=/usr/lib/systemd/system/proscan.service
    if [ ! -f $RC ]
    then
	echo "proscan.service not found. installed $RC" >> $logfile
	cp proscan.service $RC >> $logfile
	systemctl daemon-reload
    else
	echo "$RC already installed" >> $logfile
	echo "backup proscan.service" >> $logfile
	mv $RC $RC.$$ >> $logfile
	cp proscan.service $RC >> $logfile
	echo "new proscan.service installed" >> $logfile
	systemctl daemon-reload
    fi
elif [ $SUSE -eq 1 ]
then
    if [ $VERSION -le 11 ]
    then
	RC=/etc/init.d/proscan
	cp -p $BASE_DIR/contrib/proscan $RC >> $logfile
	echo "cp -p $BASE_DIR/contrib/proscan $RC" >> $logfile
	chmod a+x $RC >> $logfile
	echo "chmod a+x $RC" >> $logfile
	chkconfig proscan on > /dev/null 2>&1
    else
	RC=/usr/lib/systemd/system/proscan.service
	echo "cp proscan.service $RC" >> $logfile
	cp proscan.service $RC >> $logfile
	systemctl daemon-reload
    fi
fi

# setting Sub System
install_subsys
echo $subsystem > "$BASE_DIR/contrib/.subsystem"

# Key install
if [ "$key" != "" ]
then
    if [ -f $key ]
    then
	if [ "$key" != "$VAR_DIR/db/keys/proscan3.key" ]
	then
	    cp $key $VAR_DIR/db/keys/proscan3.key
	fi
        echo $reg > $VAR_DIR/db/keys/regist.code
    else
        echo "$key file not found."
        exit 1
    fi
else
    if [ -f $CURRENT_DIR/proscan3.key ]
    then
        cp $CURRENT_DIR/proscan3.key $VAR_DIR/db/keys
    else
        echo "Please get license key file first."
        exit 1
    fi
fi

# Update test
if [ "$UPDATER" = "on" ]
then
	UPDATE_PROTOCOL=`grep -v "^#" $CONFIG_DIR/proscan.conf| grep UpdateProtocol |awk -F= '{print $2}'|tr [:upper:] [:lower:]`
	UPDATE_HOST=`grep -v "^#" $CONFIG_DIR/proscan.conf| grep UpdateHost |awk -F= '{print $2}'|cut -d, -f1`
	UPDATE_PORT=`grep -v "^#" $CONFIG_DIR/proscan.conf| grep UpdatePort |awk -F= '{print $2}'`
	if [ "$UPDATE_PORT" -eq "80" -o "$UPDATE_PORT" -eq "443" ]
	then
	    $WGET -q -t 1 -T 1 -O /dev/null $UPDATE_PROTOCOL://$UPDATE_HOST/clamav/idx/$INDEX_FILE
	else
	    $WGET -q -t 1 -T 1 -O /dev/null $UPDATE_PROTOCOL://$UPDATE_HOST:$UPDATE_PORT/clamav/idx/$INDEX_FILE
	fi
	if [ $? -eq 0 ]
	then
	    export $LIB_PATH_SET
	    $BASE_DIR/bin/proscanup -V >> $logfile 2>&1
	    UPDATE=$?
	else
	    UPDATE=1
	fi
else
    UPDATE=1
fi

if [ $UPDATE -eq 0 ]
then
    CHK=`crontab -l 2> /dev/null|grep proscanupdate`
    if [ ! -f /etc/cron.hourly/proscan_update -a "$CHK" = "" ]
    then
        MIN=`export LANG=C;perl -e '@T=localtime;print $T[1]*60;' 2> /dev/null`
        sed -e "s/1320/$MIN/" $BASE_DIR/contrib/update.cron > /etc/cron.hourly/proscan_update
        chmod a+x /etc/cron.hourly/proscan_update
    fi
else
    echo "could not access update server" >> $logfile
fi

# set crontab
CHK=`crontab -l 2> /dev/null| grep rotate_log.sh`
if [ ! -f /etc/cron.daily/proscan_rotate_log -a "$CHK" = "" ]
then
    cp $BASE_DIR/contrib/rotate_log.cron /etc/cron.daily/proscan_rotate_log
    chmod a+x /etc/cron.daily/proscan_rotate_log
    echo "setup logrotate script at cron" >> $logfile
fi

# ProScan start
if [ $CLAMD_RUN -eq 1 ]
then
	echo "ProScan starting!" >> $logfile
	if [ -x $RC ]
	then
		$RC start >> $logfile
	elif [ $RHEL -eq 1 ]
	then
		systemctl start proscan.service >> $logfile
	elif [ $SUSE -eq 1 -a $VERSION -le 11 ]
	then
		$RC start >> $logfile
	else
		systemctl start proscan.service >> $logfile
	fi
	RETVAL=$?
else
	RETVAL=0
fi
if [ $RETVAL -ne 0 ]
then
   echo "auto install invalid. see detail logfile.($logfile)"
   exit 1
fi

echo "auto install complete"
exit 0
