#!/bin/sh
#-----------------------------------------------------------
# ProScan Installer Ver. 2.2
#-----------------------------------------------------------
# All Rights Reserved, Copyright (C) Promark Inc. 2004-2006
#-----------------------------------------------------------
# release 2.2.8
# 
# command path
PATH=/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/bin:/usr/sbin:/usr/local/sbin
export PATH

usage() {
    echo "proscan_setup.sh user bin_path var_path config"
}

user=$1
bin_path=$2
var_path=$3
config=$4

if [ "$user" = "" -o "$bin_path" = "" -o "$var_path" = "" -o "$config" = "" ]
then
    usage
    exit 1
fi

# check exec uid
ID=`id|grep 'uid=0(root)'`
if [ "$ID" = "" ]
then
    echo "You must run this program as root."
    exit 1
fi

CHK=`egrep "^${user}\:" /etc/passwd`
if [ "$CHK" = "" ]
then
    echo "$user not found"
    exit 1
fi

if [ ! -d "$bin_path" ]
then
    mkdir $bin_path
fi
cp -pr /opt/proscan/bin $bin_path/bin
chown $user $bin_path

if [ ! -d "$var_path" ]
then
    mkdir $var_path
    mkdir $var_path/log
    mkdir $var_path/run
    mkdir $var_path/tmp
    mkdir $var_path/save
    mkdir $var_path/quarantine
    mkdir $var_path/db
    mkdir $var_path/db/keys
fi
cp -p /var/opt/proscan/db/keys/* $var_path/db/keys
chown -R $user $var_path

# make config

echo "s!/var/opt/proscan/!$var_path/!g
s!=/opt/proscan/!$bin_path/!g" > /tmp/$$.sed
sed -f /tmp/$$.sed /etc/opt/proscan/proscan.conf > /etc/opt/proscan/$config
rm /tmp/$$.sed

echo "*** please start up ProScan following command"
echo "*** $bin_path/bin/proscan -c /etc/opt/proscan/$config -u $user"
