#!/bin/sh
#----------------------------------------------------------
# ProScan Log rotation script
#
PATH=/usr/bin:/usr/sbin:/bin
LOGDIR=/var/opt/proscan/log
LOGFILE="filescanner.log updater.log proscan.log smtpscanner.log clamd.log"
GEN=10
COMPRESS=1
GZIP=/bin/gzip

rm_file() {
    if [ "$2" = "1" ]
    then
        file=$1.gz
    else
        file=$1
    fi
    if [ -f $file ]
    then
        rm $file
    fi
}

mv_file() {
    if [ $3 -eq 1 ]
    then
        if [ -f $1 ]
        then
            $GZIP $1
        fi
        file1=$1.gz
        file2=$2.gz
    else
        file1=$1
        file2=$2
    fi
    if [ -f $file1 ]
    then
        mv $file1 $file2
    fi
}

cp_file() {
    if [ -f $1 ]
    then
        cp $1 $2
        cat /dev/null > $1
        if [ $3 -eq 1 -a -f $2 ]
        then
            $GZIP $2
        fi
    fi
}

rotate() {
    FILE=$1
    rm_file ${FILE}.${GEN} $COMPRESS
    i=`expr $GEN - 1`
    while [ $i -gt 0 ]
    do
        j=`expr $i + 1`
        mv_file ${FILE}.$i ${FILE}.$j $COMPRESS
        i=`expr $i - 1`
    done
    cp_file ${FILE} ${FILE}.1 $COMPRESS
}

cd $LOGDIR
for log in $LOGFILE
do
    if [ -f $log ]
    then
        rotate $log
    fi
done

