#!/bin/sh
#-----------------------------------------------------------
# ProScan Uninstaller Ver. 2.6
#-----------------------------------------------------------
# All Rights Reserved, Copyright (C) Promark Inc. 2003-2024
#-----------------------------------------------------------
# release 2.6.0
# 
# command path
PATH=/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/bin:/usr/sbin:/usr/local/sbin
export PATH
LANG=ja_JP.utf-8
export LANG

OPT=$1
if [ "$OPT" = "" ]
then
    OPT=silent
fi

# function
msg() {
    M=$1
    N=$2
    R=$3
    
    if [ "$OPT" != "silent" ]
    then
	    ja1="コンフィグファイルが見つかりません"
	    en1="Config file not found."
	    ja2="ProScanは既にアンインストール済みです"
	    en2="ProScan was already uninstalled"

	    ja10="MTAの設定ファイルの格納先は？ "
	    en10="What directory contains the MTA config file? "
	    ja11="MTA設定ファイルが見つかりません"
	    en11="MTA configuration file not found"

	    ja90="正しい番号を選択してください"
	    en90="Select a number"
	    ja99="ProScanのアンインストールは完了しました"
	    en99="ProScan component uninstall complete"

	    eval MSG=\$$M$N
	    if [ "$R" = "1" ]
	    then
	        echo -n "$MSG"
	        echo -n "$MSG" >> $logfile
	    else
	        echo "$MSG"
	        echo "$MSG" >> $logfile
	    fi
	fi
}

uninstall_proscan() {
    chkconfig --del proscan > /dev/null 2>&1
    if [ $? != 0 ]
    then
        msg $MODE 2
    fi
    
    # directory delete
    if [ -d $BASE_DIR ]
    then
        rm -fr $BASE_DIR
    fi
    if [ -d $CONFIG_DIR ]
    then
        rm -fr $CONFIG_DIR
    fi
    if [ -d $VAR_DIR ]
    then
        rm -fr $VAR_DIR
    fi

    # init script delete
    if [ -f $RC ]
    then
        rm -f $RC 
    fi
    
    # cron entry delete
    if [ -f /etc/cron.hourly/proscan_update ]
    then
        rm -f /etc/cron.hourly/proscan_update
	CHK=`ps ax|grep proscan_update|grep -v grep`
	if [ "$CHK" != "" ]
	then
	    PID=`echo $CHK | awk '{print $1}'`
	    kill $PID
	fi
    fi
    if [ -f /etc/cron.daily/proscan_rotate_log ]
    then
        rm -f /etc/cron.daily/proscan_rotate_log
    fi

    # ClamAV delete
    if [ -d /usr/lib/clamav ]
    then
        rm -fr /usr/lib/clamav
    fi
    if [ -d /etc/clamav ]
    then
	rm -fr /etc/clamav
    fi
    # ClamAV config delete
    if [ -d "/etc/clamd.d" ]
    then
	rm -fr /etc/clamd.d
    fi
    if [ -f /etc/freshclam.conf ]
    then
	rm -f /etc/freshclam.conf
    fi

    if [ -f /etc/ld.so.conf.d/proscan_s390.conf ]
    then
	rm -f /etc/ld.so.conf.d/proscan_s390.conf
        ldconfig
    fi
}

# main

# check exec uid
ID=`id|grep 'uid=0(root)'`
if [ "$ID" = "" ]
then
    echo "You must run this program as root."
    exit 1
fi

# initial
CURRENT_DIR=`pwd`

# Logfile
logfile=$CURRENT_DIR/proscan_uninstall_`date "+%Y%m%d"`.log
echo "install mode: $OPT" > $logfile
echo "PWD:$CURRENT" >> $logfile

# OS type check
OS=`uname`
echo "OS:$OS" >> $logfile

BASE_DIR=/opt/proscan
CONFIG_DIR=/etc/opt/proscan
VAR_DIR=/var/opt/proscan
MAN_DIR=/usr/share/man
CRON_TAB=/tmp/crontab.proscan
RC=/etc/init.d/proscan

# aveserver check
$RC stop > /dev/null 2>&1
echo "If run ave, stop ave." >> $logfile

if [ "$OPT" != "silent" ]
then

	# Installer start
	clear
	echo "*** ProScan enterprise for IBM Z 6.0 Uninstaller started."
	echo "*** Copyright (C) Promark Inc. 2003-2024" 
	echo ""

	# check japanese mode
	echo -n "このメッセージが読めますか？(Do you read this japanese message(UTF8)?)[y/n] "
	read ANS
	if [ "$ANS" = "N" -o "$ANS" = "n" -o "$ANS" = "NO" -o "$ANS" = "no" ]
	then
	    MODE=en
	else
	    MODE=ja
	fi
else
	MODE=en
fi

# SUBSYS config
if [ -f .subsystem ]
then 
    SUBSYS=`cat .subsystem`
fi
if [ "$SUBSYS" = "" ]
then
    SUBSYS=none
fi
echo "SUBSYS:$SUBSYS" >> $logfile

CONFIG_FILE=$BASE_DIR/contrib/$SUBSYS.conf
if [ -f "$CONFIG_FILE" ]
then
    . $CONFIG_FILE
else
    if [ "$SUBSYS" != "none" ]
    then
	echo $CONFIG_FILE
	OPT=verbose
	msg $MODE 1
	exit 1
    fi
fi
echo "set sub system functions" >> $logfile


if [ "$OPT" != "silent" ]
then
	if [ "$MODE" = "ja" ]
	then
	    echo "以下のアンインストールオプションを選択してください"
	    echo ""
	    echo "1. MTAの設定に対する変更のみアンイストール（ProScanは停止）"
	    echo "2. ProScanのモジュールの完全削除"
	    echo ""
	    echo -n "番号は？[1,2] "
	else
	    echo "Please select uninstall option."
	    echo ""
	    echo "1. Uninstall of MTA setting only (ProScan terminated)"
	    echo "2. All ProScan component uninstall"
	    echo ""
	    echo -n "which number?[1,2] "
	fi

	read ANS
else
	ANS=2
fi
echo "select option:$ANS" >> $logfile 

case $ANS in
  1)
    if [ "$SUBSYS" != "none" ]
    then
       stop_subsys
       uninstall_subsys
    fi
    ;;
  2)
    if [ "$SUBSYS" != "none" ]
    then
       stop_subsys
       uninstall_subsys
    fi
    uninstall_proscan
    ;;
  *)
    OPT=verbose
    msg $MODE 90
    exit 1
    ;;
esac


# MTA restart
if [ "$SUBSYS" != "none" ]
then
    start_subsys
fi

OPT=verbose
msg $MODE 99
exit 0
